/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JaxbXmlReader<T> {
    private static final Logger log = LoggerFactory.getLogger(JaxbXmlReader.class);
    private String lastError;
    private final Class<T> typeParameterClass;
    private final Schema schema;
    private final JAXBContext jaxbContext;

    @SafeVarargs
    public JaxbXmlReader(@Nonnull URL schemaUrl, @Nonnull Class<T> typeParameterClass, Class<? extends T> ... typeParameterSubclasses) {
        Preconditions.checkNotNull(schemaUrl);
        Preconditions.checkNotNull(typeParameterClass);
        this.typeParameterClass = typeParameterClass;
        try {
            this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            this.jaxbContext = typeParameterSubclasses.length == 0 ? JAXBContext.newInstance((Class[])new Class[]{typeParameterClass}) : JAXBContext.newInstance((Class[])typeParameterSubclasses);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Cannot parse XSD schema " + schemaUrl, e);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot initialize JAXB context", e);
        }
    }

    public JaxbXmlReader(@Nonnull Class<T> typeParameterClass, @Nonnull URL schemeUrl) {
        this(schemeUrl, typeParameterClass, new Class[0]);
    }

    public Optional<T> read(@Nonnull Path path) {
        Preconditions.checkNotNull(path);
        try {
            return this.read(path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            this.reportError("Error reading xml file.", e);
            return Optional.empty();
        }
    }

    public Optional<T> read(@Nonnull URL url) {
        Optional<T> optional;
        block8: {
            Preconditions.checkNotNull(url);
            InputStream input = url.openStream();
            try {
                optional = Optional.ofNullable(this.read(input, FilenameUtils.getName((String)url.getPath())));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.reportError("Error reading xml file", e);
                    return Optional.empty();
                }
            }
            input.close();
        }
        return optional;
    }

    public T read(@Nonnull InputStream input, @Nonnull String fileName) {
        Preconditions.checkNotNull(input);
        try {
            Unmarshaller jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setSchema(this.schema);
            return this.typeParameterClass.cast(jaxbUnmarshaller.unmarshal(input));
        }
        catch (JAXBException e) {
            Throwable throwable = e.getLinkedException();
            if (throwable instanceof SAXParseException) {
                SAXParseException le = (SAXParseException)throwable;
                this.reportError(String.format("'%s' - Parsing error on line %s column %s: %s", fileName, le.getLineNumber(), le.getColumnNumber(), le.getMessage()), le);
            } else {
                this.reportError(String.format("Unable to parse '%s'", fileName), e);
            }
            return null;
        }
    }

    private void reportError(@Nonnull String msg, @Nonnull Throwable e) {
        this.lastError = msg + ": " + e.getMessage();
        log.debug(this.lastError, e);
    }

    public String getLastError() {
        return this.lastError;
    }
}

